/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.traceroute.RemotePing;
import ibm.nways.jdm.traceroute.RemotePingException;
import ibm.nways.jdm.traceroute.Util;
import java.util.ResourceBundle;

public class RemotePingIBM
extends RemotePing {
    private static ResourceBundle strings = ResourceBundle.getBundle((RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources : (RemotePing.class$ibm$nways$jdm$traceroute$TraceRouteResources = RemotePing.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    private static final String IBM_REMOTE_PING_OID = "1.3.6.1.4.1.2.6.4.3.1";
    private static final boolean debug = false;

    public RemotePingIBM(IPAddress iPAddress, String string, String string2) {
        super(iPAddress, string, strings.getString("RemotePingIBM"), string2);
    }

    public int remotePing(IPAddress iPAddress, int n, int n2, int n3) throws RemotePingException {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = this.remotePing(iPAddress, n2, n3);
            n4 += n6;
            ++n5;
        }
        return n4 / n;
    }

    protected int remotePing(IPAddress iPAddress, int n, int n2) throws RemotePingException {
        String string = "1.3.6.1.4.1.2.6.4.3.1." + n + "." + n2;
        String string2 = String.valueOf(string) + "." + iPAddress.toString();
        Object[] objectArray = Util.lookupMibVars(this.ipAddress, this.communityName, new String[]{string2}, this.voyagerAddress);
        if (objectArray[0] == null) {
            throw new RemotePingException(1);
        }
        this.pingSupported = true;
        int n3 = (Integer)objectArray[0];
        switch (n3) {
            case -3: 
            case -1: {
                throw new RemotePingException(6);
            }
            case -2: {
                throw new RemotePingException(5);
            }
            case -4: {
                throw new RemotePingException(2);
            }
            case -5: {
                throw new RemotePingException(3);
            }
        }
        return n3;
    }
}

